﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Kz.GammaTech.Ocsp;
using Kz.GammaTech.X509;
using Kz.GammaTech.Utilities.Encoders;
using Kz.GammaTech.Math;
using System.IO;
using System.DirectoryServices.Protocols;
using Kz.GammaTech.Asn1.X509;
using Kz.GammaTech.Crypto;
using Kz.GammaTech.Asn1.Gamma;
using Kz.GammaTech.Pkcs;
using Kz.GammaTech.Asn1.Ocsp;
using Kz.GammaTech.Asn1;


namespace OcspExample
{
    class Program
    {
        static void Main(string[] args)
        {
            byte[] cert10 = Base64.Decode("MIIDCTCCArKgAwIBAgIg9cQ9aKqVgQzJ+SAxZDIfh7mrz6X/blKg7difgQI/wtww"
                                        + "DgYKKwYBBAG1EQECAgUAMC0xCzAJBgNVBAMTAkNBMREwDwYDVQQKEwhERUNFTUJF"
                                        + "UjELMAkGA1UEBhMCS1owIhgPMjAwOTAxMDgxMTI1MzBaGA8yMDEwMDEwODExMjUz"
                                        + "MFowKjEMMAoGA1UEAxMDMTI4MQ0wCwYDVQQKEwRMRU5BMQswCQYDVQQGEwJLWjBj"
                                        + "MA4GCisGAQQBtREBBQgFAANRAAYCAAA6qgAAAEVDMQACAABZYQwWwBPerAqztrms"
                                        + "XKnpkCF6NXhPJgzqvZOo+isHcuOvIkUOvsi1VdhIENUm2yAgT7l6Z5ZBTku92JwV"
                                        + "+Ov5o4IBkzCCAY8wCwYDVR0PBAQDAgbAMBMGA1UdJQQMMAoGCCsGAQUFBwMEMEEG"
                                        + "CCsGAQUFBwEBBDUwMzAxBggrBgEFBQcwAYYlaHR0cDovLzE5Mi4xNjguNy40Mzo2"
                                        + "MjI4MC9jZ2kvc3RhdHVzADApBgNVHQ4EIgQg9cQ9aKqVgQzJ+SAxZDIfh7mrz6X/"
                                        + "blKg7difgQI/wtwwgYAGA1UdIwR5MHeAIC/wr3HUOhoNvruGyzL2+Xc4KX8mhA/X"
                                        + "Zg7M3qxCLJqnoTGkLzAtMQswCQYDVQQDEwJDQTERMA8GA1UEChMIREVDRU1CRVIx"
                                        + "CzAJBgNVBAYTAktagiAv8K9x1DoaDb67hssy9vl3OCl/JoQP12YOzN6sQiyapzB6"
                                        + "BgNVHSAEczBxMG8GCisGAQQBtRELAQUwYTAfBggrBgEFBQcCARYTaHR0cDovL3d3"
                                        + "dy5nYW1tYS5rejA+BggrBgEFBQcCAjAyMBIWC1Rlc3QgUG9saWN5MAMCAQEaHENl"
                                        + "cnRpZmljYXRlIFBvbGljZXMgU3RhdG1lbnQwDgYKKwYBBAG1EQECAgUAA0EAQPjC"
                                        + "a20Hh2+q7aMceuoW2spEJA9kURP568MWTNliejAGRwcOOgYfnpCj9yU5dZhtMU8c"
                                        + "x22Kozxii4w95RUBXw==");
            byte[] cert2 = Base64.Decode("MIICajCCAhOgAwIBAgIgxTI11QcLhjew5CvHFslx1Uv1K7mCS9OcC20GwoO/Iu8w"
+"DgYKKwYBBAG1EQECAgUAMCkxCzAJBgNVBAMTAkNBMQ0wCwYDVQQKEwRLSVNDMQsw"
+"CQYDVQQGEwJLWjAiGA8yMDA5MTAwOTA0MzMzMloYDzIwMDkxMDIzMDQzMzMyWjAs"
+"MQ4wDAYDVQQDEwVMZW5hMjENMAsGA1UEChMES0lTQzELMAkGA1UEBhMCS1owYzAO"
+"BgorBgEEAbURAQUIBQADUQAGAgAAOqoAAABFQzEAAgAAlnc3yjY8GLOIRAzgOiQs"
+"tWpRagrxysjKAhwHfX10xqc1NJ+cw6oSpP+lo1dpoShiA/FqEa4aR18DCLMYLxr9"
+"NaOB9zCB9DALBgNVHQ8EBAMCBsAwEwYDVR0lBAwwCgYIKwYBBQUHAwQwOgYDVR0f"
+"BDMwMTAvoC2gK4YpaHR0cHM6Ly8xOTIuMTY4LjcuNjo2MjI4MC9jZ2kvUmV2TGlz"
+"dC5jcmwwKQYDVR0OBCIEIMUyNdUHC4Y3sOQrxxbJcdVL9Su5gkvTnAttBsKDvyLv"
+"MGkGA1UdIwRiMGCAILqRYBzlPl2EpoHNaK0VnCK7jCLNb/HV17GjmeAzmiUloRqG"
+"GGh0dHA6Ly8xOTIuMTY4LjcuNjo2MjI4MIIgupFgHOU+XYSmgc1orRWcIruMIs1v"
+"8dXXsaOZ4DOaJSUwDgYKKwYBBAG1EQECAgUAA0EApY3FC/3mBTNE1MeWNzfVeIKo"
+"eZ/KFeE7Q9PBuTPetWt30puflUtpXL4RjMAJ0H0ywT5qxWirLfr0ldtQfAHWjw==");
           

            byte[] cert1 = Base64.Decode("MIICajCCAhOgAwIBAgIgu9ZoEbENu6wWcKAVUGEUNz25hlr6fvPd5doe2CE7jicw"
+"DgYKKwYBBAG1EQECAgUAMCkxCzAJBgNVBAMTAkNBMQ0wCwYDVQQKEwRLSVNDMQsw"
+"CQYDVQQGEwJLWjAiGA8yMDA5MTAwOTA0MzMyOFoYDzIwMDkxMDIzMDQzMzI4WjAs"
+"MQ4wDAYDVQQDEwVMZW5hMTENMAsGA1UEChMES0lTQzELMAkGA1UEBhMCS1owYzAO"
+"BgorBgEEAbURAQUIBQADUQAGAgAAOqoAAABFQzEAAgAA+3EC6QRkvXa1AHgV3vV3"
+"o03TvPqhscr8psqg3ziy2g7fE9O6/MUV2uilMIgdfohUqsnCTVWwiSnNPFHrXJTY"
+"zaOB9zCB9DALBgNVHQ8EBAMCBsAwEwYDVR0lBAwwCgYIKwYBBQUHAwQwOgYDVR0f"
+"BDMwMTAvoC2gK4YpaHR0cHM6Ly8xOTIuMTY4LjcuNjo2MjI4MC9jZ2kvUmV2TGlz"
+"dC5jcmwwKQYDVR0OBCIEILvWaBGxDbusFnCgFVBhFDc9uYZa+n7z3eXaHtghO44n"
+"MGkGA1UdIwRiMGCAILqRYBzlPl2EpoHNaK0VnCK7jCLNb/HV17GjmeAzmiUloRqG"
+"GGh0dHA6Ly8xOTIuMTY4LjcuNjo2MjI4MIIgupFgHOU+XYSmgc1orRWcIruMIs1v"
+"8dXXsaOZ4DOaJSUwDgYKKwYBBAG1EQECAgUAA0EAemvKC1evAdoSAajWW4hCxKjD"
+"pemJR2Fvg6Q+ir8ECqNhRUoona5K5/bcT38S37sLKG9zI5FiCVmpJg5+0nGCaQ==");

            byte[] root = Base64.Decode("MIICPDCCAeWgAwIBAgIgupFgHOU+XYSmgc1orRWcIruMIs1v8dXXsaOZ4DOaJSUw"
+"DgYKKwYBBAG1EQECAgUAMCkxCzAJBgNVBAMTAkNBMQ0wCwYDVQQKEwRLSVNDMQsw"
+"CQYDVQQGEwJLWjAeFw0wOTAzMDIxMzAxNTBaFw0xOTAyMjgxMzAxNTBaMCkxCzAJ"
+"BgNVBAMTAkNBMQ0wCwYDVQQKEwRLSVNDMQswCQYDVQQGEwJLWjBjMA4GCisGAQQB"
+"tREBBQgFAANRAAYCAAA6qgAAAEVDMQACAABBg40oAsCcHx3ZhJesrDh04ZzVEEci"
+"AZiAsQcmt8IVWjjGDeEGuEBjuorGlFtIm+Sqmo1Uuzn0KvxdPRloXU/so4HQMIHN"
+"MBIGA1UdEwEB/wQIMAYBAf8CAQMwDgYDVR0PAQH/BAQDAgEGMCkGA1UdDgQiBCC6"
+"kWAc5T5dhKaBzWitFZwiu4wizW/x1dexo5ngM5olJTB8BgNVHSMEdTBzgCC6kWAc"
+"5T5dhKaBzWitFZwiu4wizW/x1dexo5ngM5olJaEtpCswKTELMAkGA1UEAxMCQ0Ex"
+"DTALBgNVBAoTBEtJU0MxCzAJBgNVBAYTAktagiC6kWAc5T5dhKaBzWitFZwiu4wi"
+"zW/x1dexo5ngM5olJTAOBgorBgEEAbURAQICBQADQQCl0CeYNVU9rDUMKYHTCGU+"
+"uUci/Bni+pn0zHt+k8vgaU1d9+fQzwxamWnKjh1P8Hx7OhHhhUZVYifRyo4dYK9U");



           X509Certificate cert = new X509CertificateParser().ReadCertificate(cert1);
           X509Certificate cert_root = new X509CertificateParser().ReadCertificate(root);
           byte[] root_serial = new byte[32];

           Asn1OctetString serial = cert.GetExtensionValue(X509Extensions.AuthorityKeyIdentifier);
           if (serial != null)
           {
               AuthorityKeyIdentifier aki = AuthorityKeyIdentifier.GetInstance(
                   Asn1Object.FromByteArray(serial.GetOctets()));

               if (aki.GetKeyIdentifier() != null)
               {
                   root_serial = aki.GetKeyIdentifier(); 
                      
               }
           }

           X509Name issuer_name = cert_root.IssuerDN;
                                

            
           CertificateID id = new CertificateID(CertificateID.HashGost, cert_root, cert.SerialNumber);
                                       
            OcspReqGenerator gen = new OcspReqGenerator();
            gen.AddRequest(id);         
            gen.SetRequestorName(cert.SubjectDN);         
            X509Certificate[] chain = new X509Certificate[1];
            chain[0] = cert;          
            OcspReq req = gen.Generate(GammaObjectIdentifiers.GostR3410x2001.Id, null, chain);

            FileInfo f = new FileInfo("req.bin");
            FileStream f1 = f.OpenWrite();
            f1.Write(req.GetEncoded(), 0, req.GetEncoded().Length);
            f1.Close();
            

         

            LdapDirectoryIdentifier dir_id = new LdapDirectoryIdentifier("192.168.7.6",62222);
                       
            LdapConnection ldap_connect = new LdapConnection(dir_id);


            ldap_connect.AuthType = AuthType.Basic;           
            ldap_connect.Bind();
                        
            ExtendedRequest ldap_req = new ExtendedRequest("1.3.6.1.4.1.6801.11.1.1", req.GetEncoded());

            

            DirectoryResponse ldap_resp = ldap_connect.SendRequest(ldap_req);

            ExtendedResponse ldap_resp2 =(ExtendedResponse) ldap_resp;

            OcspResp ocsp_resp = new OcspResp(ldap_resp2.ResponseValue);

            OCSPHelper hlp = new OCSPHelper();
            
            
            

            if (ocsp_resp.Status == 0) { Console.WriteLine("Done"); }
            else Console.WriteLine("Error");

            BasicOcspResp basic_resp = (BasicOcspResp) ocsp_resp.GetResponseObject();



            SingleResp[] singleResp = basic_resp.Responses;
            int[] StatusArray = new int[singleResp.Length];

            for (int i = 0; i < singleResp.Length; i++)
            {
               
                try
                {
                    CertStatus s = (CertStatus)singleResp[i].GetCertStatus();
                    StatusArray[i] = 0;
                }
                catch (InvalidCastException e)
                {
                    try
                    {
                        RevokedStatus s = (RevokedStatus)singleResp[i].GetCertStatus();
                        
                        StatusArray[i] = 1;
                    }
                    catch (InvalidCastException e1)
                    {
                        StatusArray[i] = 2;
                    }

                }
                

            }

            for (int i = 0; i < StatusArray.Length; i++)
            {
                if (StatusArray[i] != 0) Console.WriteLine("Status not OK");
                else Console.WriteLine("Status OK");
            }

            FileInfo f10 = new FileInfo("resp.bin");
            FileStream f11 = f10.OpenWrite();
            f11.Write(ocsp_resp.GetEncoded(), 0, ocsp_resp.GetEncoded().Length);
            f11.Close();
            

            Console.ReadKey();
            
           
        }
    }
}
